#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
	nl = []   # ispravno formatirane linije

	n = int(lines[0])
	assert 1 <= n <= 100, "n kriv"
	nl.append("{}\n".format(n))
	
	last = -1
	jed = 1
	pi = list(map(int, lines[1].strip().split()))
	nl.append(("{}" + " {}"*(n - 1) + "\n").format(*pi))
	
	for i in range(n):
		if not i: last = pi[i]
		else:
			if last != pi[i]: jed = 0
	for x in pi:
		assert 1 <= x <= 200, 'pi kriv'
	
	m = int(lines[2])
	nl.append("{}\n".format(m))
	assert 1 <= m <= 100, "m kriv"

	for i in range(m):
		ln = lines[3 + i].strip().split()
		zi = int(ln[0])
		vri = ln[1]
		assert len(vri) == 5, "vrijeme krivo"
		assert 1 <= zi <= 200, "zi kriv"
		assert vri[2] == ':', "dvotocka kriva"
		h = int(vri[0:2])
		m = int(vri[3:5])
		assert 8 <= h < 24, "sati krivi"
		assert 0 <= m < 60, "minute krive"
		nl.append("{} {}:{}\n".format(zi,vri[0:2],vri[3:5]))


	assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
	assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
	return n, jed

# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'n = 1': 3, 'jednaki' : 3, 'normalni' : 4}

def what_cluster(data):
	n, jed = data
	if n == 1: return 'n = 1'
	if jed: return 'jednaki'
	return 'normalni'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
	# mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

	files.sort()
	B = []
	for f in files:
		if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
			B[-1].append(f)
		else:
			B.append([f])
	return B


if __name__ == "__main__":
	f = []
	for pattern in sys.argv[1:]:
		for filename in glob.glob(pattern):
			f.append(filename)

	bc = []
	for batch in group_in_batches(f):
		if 'dummy' not in batch[0]:
			bc.append([])
			for filename in batch:
				print("{}: ".format(filename), end="")
				try:
					lines = open(filename).readlines()
					summary = check(lines)
					c = what_cluster(summary)
					if 'dummy' not in batch[0]:
						bc[-1].append(c)
				except Exception as e:
					print("Greska!", e)
					raise
				else:
					print("Sve ok! (cluster {}, summary = {})".format(c, summary))
	clusters = {}
	for b in bc:
		for c in b:
			assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
		if not b[0] in clusters:
			clusters[b[0]] = 0
		clusters[b[0]] += 1

	assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

	# Buda test - provjeri duplikate
	hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
	assert len(hashes) == len(f), "Ima duplikata!"
